<?php

namespace RFTenant\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RfCommunity extends Model 
{

    protected $table = 'rf_communities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'country_id', 'currency_id', 'district_id', 'city_id', 'map', 'is_active', 'created_by', 'updated_by');

    public function country()
    {
        return $this->belongsTo('RFTenant\Models\Country');
    }

    public function currency()
    {
        return $this->belongsTo('RFTenant\Models\Currency');
    }

    public function district()
    {
        return $this->belongsTo('RFTenant\Models\District');
    }

    public function city()
    {
        return $this->belongsTo('RFTenant\Models\City');
    }

    public function buildings()
    {
        return $this->hasMany('RFTenant\Models\RfBuildings');
    }

    public function units()
    {
        return $this->hasMany('RFTenant\Models\RfUnits');
    }

}